/*
 * Decompiled with CFR 0.152.
 */
package jclass.datasource.vcafe25;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import jclass.datasource.BaseMetaData;
import jclass.datasource.ColumnModel;
import jclass.datasource.DataModelEvent;
import jclass.datasource.DataModelException;
import jclass.datasource.DataModelListener;
import jclass.datasource.DataTableModel;
import jclass.datasource.IdeDataTable;
import jclass.datasource.IdeMetaData;
import jclass.datasource.LocaleBundle;
import jclass.datasource.MetaDataModel;
import jclass.datasource.treemodel.TreeNode;
import jclass.datasource.vcafe25.MetaData;
import symantec.itools.db.beans.binding.PersistentObject;
import symantec.itools.db.beans.binding.QueryNavigator;

public class DataTable
extends IdeDataTable {
    static final long serialVersionUID = 6617497792116806134L;
    QueryNavigator dataSet;

    public DataTable(MetaDataModel metaDataModel, QueryNavigator queryNavigator) throws DataModelException {
        super(metaDataModel);
        this.init(queryNavigator, metaDataModel);
    }

    public DataTable(MetaDataModel metaDataModel, QueryNavigator queryNavigator, long l) throws DataModelException {
        super(metaDataModel, l);
        this.init(queryNavigator, metaDataModel);
    }

    private void init(QueryNavigator queryNavigator, MetaDataModel metaDataModel) throws DataModelException {
        try {
            this.dataSet = queryNavigator;
            this.metaData = metaDataModel;
            this.copyTable();
            return;
        }
        catch (Exception exception) {
            throw new DataModelException(107, exception);
        }
    }

    public void copyTable() throws Exception {
        int n = this.dataSet.getTotalNumberOfRows();
        int n2 = 0;
        while (n2 < n) {
            PersistentObject persistentObject = (PersistentObject)this.dataSet.getElementAt(n2);
            this.addInternalRow(this.duplicateIdeRow(persistentObject));
            ++n2;
        }
    }

    private Object[] duplicateIdeRow(PersistentObject persistentObject) throws Exception {
        Object[] objectArray = new Object[this.metaData.getColumnCount()];
        int n = 0;
        while (n < objectArray.length) {
            String string = this.getMetaData().getColumnIdentifier(n);
            int n2 = ((MetaData)this.getMetaData()).getIdeColumnIndexFromName(string);
            Object object = persistentObject.getValueAsObject(n2, 1);
            objectArray[n] = this.convertToProperObjectType(object);
            ++n;
        }
        return objectArray;
    }

    public Object[] duplicateRow(int n) throws Exception {
        return this.duplicateIdeRow((PersistentObject)this.dataSet.getElementAt(n));
    }

    public Object getCell2(long l, String string) throws Exception {
        int n = 0;
        int n2 = ((MetaData)this.getMetaData()).getIdeColumnIndexFromName(string);
        Object object = this.dataSet.getValue(n, n2);
        return this.convertToProperObjectType(object);
    }

    private Object convertToProperObjectType(Object object) throws Exception {
        if (object instanceof Short) {
            return new Integer(((Short)object).shortValue());
        }
        if (object instanceof ByteArrayInputStream) {
            return ((BaseMetaData)this.getMetaData()).createByteArrayFromBinaryStream((InputStream)object);
        }
        return object;
    }

    public void setValueAt(long l, String string, Object object) throws Exception {
        int n = 0;
        int n2 = ((MetaData)this.getMetaData()).getIdeColumnIndexFromName(string);
        this.dataSet.setValue(object, n, n2);
    }

    private void positionDataSet() {
        MetaDataModel metaDataModel = (MetaDataModel)this.metaData.getParent();
        DataTable dataTable = (DataTable)this.getParent();
        if (metaDataModel != null && dataTable != null) {
            dataTable.positionDataSet();
            try {
                QueryNavigator queryNavigator = (QueryNavigator)metaDataModel.getNativeMetaData();
                int n = dataTable.store.getIndex(this.parentRow);
                dataTable.getMetaData().setCurrentDataTable(dataTable);
                dataTable.getMetaData().setCurrentBookmark(this.parentRow);
                if (queryNavigator.getCurrentRowNumber() != ++n - 1) {
                    queryNavigator.go_to(n);
                    return;
                }
            }
            catch (Exception exception) {
                System.out.println("positionDataSet(): " + exception.toString());
                return;
            }
        }
    }

    public long addRow(DataModelListener dataModelListener) throws DataModelException {
        ColumnModel columnModel = this.metaData.getColumnObject(this.metaData.getColumnIdentifier(0));
        if (columnModel != null && !this.metaData.getInsertAllowed(columnModel.getTableName())) {
            Exception exception = new Exception(LocaleBundle.string("Insert Not Allowed"));
            throw new DataModelException(1, exception);
        }
        if (!this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, -1L, "", 1))) {
            return -1L;
        }
        this.dataSet.navigate(7, null);
        if (((MetaData)this.metaData).eventException != null) {
            DataModelException dataModelException = new DataModelException(1, ((MetaData)this.metaData).eventException);
            ((MetaData)this.metaData).eventException = null;
            throw dataModelException;
        }
        return this.bookmarkOfLastRowAdded;
    }

    public Object createNewRow() throws Exception {
        return new Object[this.metaData.getColumnCount()];
    }

    public void refreshRow(long l) throws Exception {
    }

    public void requeryRow(DataModelListener dataModelListener, long l) throws DataModelException {
        if (!this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, "", 3))) {
            return;
        }
        int n = this.getRowStatus(l);
        Long l2 = new Long(l);
        this.rowIndexBeforeEvent.put(l2, new Integer(this.store.getIndex(l)));
        if (n == 2) {
            this.getRowInternal(dataModelListener, l);
        } else {
            this.restoreRow(l);
        }
        this.rowIndexBeforeEvent.remove(l2);
    }

    public boolean commitRow(DataModelListener dataModelListener, long l) throws DataModelException {
        if (!this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, "", 10))) {
            return false;
        }
        if (this.getRowStatus(l) == 4 || this.getRowStatus(l) == 5) {
            return true;
        }
        try {
            this.saveRow(l);
        }
        catch (Exception exception) {
            throw new DataModelException(10, exception);
        }
        return true;
    }

    public void saveRow(long l) throws Exception {
        this.store.getIndex(l);
        if (this.getRowStatus(l) == 3) {
            this.dataSet.delete();
            this.dataSet.saveAll();
        } else {
            this.dataSet.saveAll(5);
        }
        if (((MetaData)this.metaData).eventException != null) {
            Exception exception = new Exception(((MetaData)this.metaData).eventException.toString());
            ((MetaData)this.metaData).eventException = null;
            throw exception;
        }
    }

    public void deleteRow(DataModelListener dataModelListener, long l) throws DataModelException {
        ColumnModel columnModel = this.metaData.getColumnObject(this.metaData.getColumnIdentifier(0));
        if (columnModel != null && !this.metaData.getDeleteAllowed(columnModel.getTableName())) {
            Exception exception = new Exception(LocaleBundle.string("Delete Not Allowed"));
            throw new DataModelException(5, exception);
        }
        if (!this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, "", 5))) {
            return;
        }
        this.turnOffDataModelEvents();
        this.dataSet.delete();
        this.dataSet.saveAll();
        this.turnOnDataModelEvents();
        if (((MetaData)this.metaData).eventException != null) {
            Exception exception = new Exception(((MetaData)this.metaData).eventException.toString());
            ((MetaData)this.metaData).eventException = null;
            throw new DataModelException(l, "", this, 102, exception);
        }
        ((IdeMetaData)this.getMetaData()).requeryCurrentRowAndBelow(this, this);
    }

    public DataTableModel materializeTable(DataModelListener dataModelListener, long l, TreeNode treeNode) throws DataModelException {
        MetaDataModel metaDataModel = (MetaDataModel)((Object)treeNode);
        this.moveToRow(l);
        DataTable dataTable = new DataTable(metaDataModel, (QueryNavigator)metaDataModel.getNativeMetaData(), l);
        metaDataModel.setCurrentDataTable(dataTable);
        long l2 = -1L;
        if (dataTable.first()) {
            l2 = dataTable.getCurrentBookmark();
        }
        metaDataModel.setCurrentBookmark(l2);
        this.getMetaData().getDataModel().moveToRow(dataModelListener, this, l);
        return dataTable;
    }

    public void moveToRow(long l) {
        this.metaData.setCurrentDataTable(this);
        this.metaData.setCurrentBookmark(l);
        if (this.getRowStatus(l) == 2) {
            return;
        }
        int n = this.store.getIndex(l);
        this.turnOffDataModelEvents();
        this.positionDataSet();
        if (this.dataSet.getCurrentRowNumber() != ++n - 1) {
            this.dataSet.go_to(n);
        }
        this.turnOnDataModelEvents();
    }

    public void cancelRowChanges(DataModelListener dataModelListener, long l) throws DataModelException {
        if (!this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, "", 8))) {
            return;
        }
        this.getRowInternal(dataModelListener, l);
    }

    private void getRowInternal(DataModelListener dataModelListener, long l) {
        try {
            this.moveToRow(l);
            this.turnOffDataModelEvents();
            if (this.getRowStatus(l) != 2) {
                this.dataSet.undoChanges();
            } else {
                this.dataSet.delete();
            }
            this.dataSet.save();
            this.turnOnDataModelEvents();
            super.cancelRowChanges(dataModelListener, l);
            return;
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            return;
        }
    }

    public DataTableModel requeryLevel() throws Exception {
        this.store.clear();
        this.logicallyDeletedRows.clear();
        this.updatedRows.clear();
        this.insertedRows.clear();
        this.ideRowIndexToBookmarkMap.clear();
        this.turnOffDataModelEvents();
        this.dataSet.restart();
        this.turnOnDataModelEvents();
        this.copyTable();
        ((IdeMetaData)this.getMetaData()).cleanChildDataSets();
        return this;
    }

    private void turnOffDataModelEvents() {
        this.getMetaData().getDataModel().enableDataModelEvents(false);
    }

    private void turnOnDataModelEvents() {
        this.getMetaData().getDataModel().enableDataModelEvents(true);
    }
}

